(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6856,        288]*)
(*NotebookOutlinePosition[      7566,        313]*)
(*  CellTagsIndexPosition[      7522,        309]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(**ZEROING\)\ EROS'\ \(INCLINATION**\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\@\(4 \( \[Pi]\^2\) \((2\/1.133082351 - 1\/1.458336481)\)\)\)], "Input"],

Cell[BoxData[
    \(6.52781517604241035`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(6.52781\ 517604241035` - \ 
      Velocity\ at\ \[CapitalOmega]\ \((AU/yr)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(6.52781517604241035`*\((1.495978707*10^11)\)\)\/\(365.2564*24*3600
        \)\)], "Input"],

Cell[BoxData[
    \(30944.372818550736`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(30944.372818550736` - Velocity\ at\ \[CapitalOmega]\ \((m/s)\)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sin[10.8308783\ Degree]\)], "Input"],

Cell[BoxData[
    \(0.187910669454103533`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(0.187910669454103533`*30944.372818550736`\)], "Input"],

Cell[BoxData[
    \(5814.77781217123457`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(5814.77781217123457` - \ Length\ of\ z\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cos[10.8308783\ Degree]\)], "Input"],

Cell[BoxData[
    \(0.982186123046599846`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(0.982186123046599846`*30944.372818550736`\)], "Input"],

Cell[BoxData[
    \(30393.1335687609305`\)], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(30393.1335687609305` - length\ of\ the\ x\  - component\ \), 
    \(\t\tof\ the\ existing\ velocity\ vector\)}], "Input"],

Cell[BoxData[
    \(30393.1335687609305`\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(30944.372818550736 - 30393.1335687609305\)], "Input"],

Cell[BoxData[
    \(551.2392497898055`14.8121\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(551.2392497898055`14.8121\  - \ The\ length\ of\ y\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\@\(5814.77781217123457`\^2 + 551.2392497898055`14.8121\^2\)\)], "Input"],

Cell[BoxData[
    \(5840.84803050273926`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(5840.84803050273926` - \ 
      The\ length\ of\ the\ hypotenuse\ of\ the\ other\ 
        "\<velocity triangle\>"\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[
      Sin[x\ Degree] \[Equal] 5814.77781217123457`\/5840.84803050273926`, x]
      \)], "Input"],

Cell[BoxData[
    \(Solve::"ifun" \( : \ \) 
      "Inverse functions are being used by \!\(Solve\), so some solutions may \
not be found."\)], "Message"],

Cell[BoxData[
    \({{x \[Rule] 84.5845608499998213`}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \({{x \[Rule] 84.5845608499998213`}}\  - \ 
      The\ angle\ the\ new\ "\<velocity triangle\>"\ makes\ with\ the\ 
        ecliptic\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(90 - 84.5845608499998213`\)], "Input"],

Cell[BoxData[
    \(5.41543915000018216`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[
      38.183766184073562`*Log[\(5*10^15\)\/x] \[Equal] 5.84084803050273926`, 
      \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 4.29079111653734202`*^15}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \({{x \[Rule] 4.29079111653734202`*^15}} - \ 
      Mass\ of\ Eros\ after\ the\ plane\ change\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(5*10^15 - 4.29079111653734202`*^15\)], "Input"],

Cell[BoxData[
    \(7.09208883462657624`*^14\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(7.09208883462657624`*^14 - \ 
      Exhaust\ mass\ expended\ during\ the\ plane\ change\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(44924*2500\)], "Input"],

Cell[BoxData[
    \(112310000\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(112310000\  - \ Rate\ of\ fire\ for\ all\ mass\ drivers\ \((kg/s)\)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(7.09208883462657624`*^14\/\(112310000\ \)\)], "Input"],

Cell[BoxData[
    \(6.31474386486205929`*^6\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(6.31474386486205929`*^6\  - \ 
      The\ number\ of\ seconds\ needed\ to\ change\ Eros'\ inclination\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(6.31474386486205929`*^6\ /60\)], "Input"],

Cell[BoxData[
    \(105245.731081034321`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(105245.731081034321` - \ The\ number\ of\ minutes\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(105245.731081034321`/60\)], "Input"],

Cell[BoxData[
    \(1754.09551801723857`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(1754.09551801723857` - \ The\ number\ of\ hours\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1754.09551801723857`/24\)], "Input"],

Cell[BoxData[
    \(73.0873132507182887`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(73.0873132507182887` - \ 
      The\ number\ of\ days\ needed\ to\ change\ Eros'\ inclination\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(73.0873132507182887`/20\)], "Input"],

Cell[BoxData[
    \(3.65436566253591399`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(3.65436566253591399` - \ 
      The\ number\ of\ 20\ day\ intervals\ needed\ to\ zero\ Eros'\ 
        inclination\)], "Input"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 640}, {0, 424}},
WindowSize->{580, 326},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 72, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[1806, 54, 92, 1, 50, "Input"],
Cell[1901, 57, 54, 1, 29, "Output"]
}, Open  ]],
Cell[1970, 61, 109, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[2104, 67, 112, 2, 42, "Input"],
Cell[2219, 71, 53, 1, 29, "Output"]
}, Open  ]],
Cell[2287, 75, 98, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[2410, 81, 56, 1, 30, "Input"],
Cell[2469, 84, 55, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2561, 90, 74, 1, 30, "Input"],
Cell[2638, 93, 54, 1, 29, "Output"]
}, Open  ]],
Cell[2707, 97, 71, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2803, 102, 56, 1, 30, "Input"],
Cell[2862, 105, 55, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2954, 111, 74, 1, 30, "Input"],
Cell[3031, 114, 54, 1, 29, "Output"]
}, Open  ]],
Cell[3100, 118, 142, 2, 50, "Input"],
Cell[3245, 122, 53, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[3323, 127, 73, 1, 30, "Input"],
Cell[3399, 130, 59, 1, 29, "Output"]
}, Open  ]],
Cell[3473, 134, 83, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[3581, 139, 93, 1, 33, "Input"],
Cell[3677, 142, 54, 1, 29, "Output"]
}, Open  ]],
Cell[3746, 146, 147, 3, 50, "Input"],

Cell[CellGroupData[{
Cell[3918, 153, 123, 3, 42, "Input"],
Cell[4044, 158, 154, 3, 44, "Message"],
Cell[4201, 163, 68, 1, 29, "Output"]
}, Open  ]],
Cell[4284, 167, 163, 3, 50, "Input"],

Cell[CellGroupData[{
Cell[4472, 174, 58, 1, 30, "Input"],
Cell[4533, 177, 54, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4624, 183, 128, 3, 42, "Input"],
Cell[4755, 188, 72, 1, 29, "Output"]
}, Open  ]],
Cell[4842, 192, 124, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[4991, 198, 67, 1, 30, "Input"],
Cell[5061, 201, 58, 1, 29, "Output"]
}, Open  ]],
Cell[5134, 205, 120, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[5279, 211, 43, 1, 30, "Input"],
Cell[5325, 214, 43, 1, 29, "Output"]
}, Open  ]],
Cell[5383, 218, 103, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[5511, 224, 74, 1, 42, "Input"],
Cell[5588, 227, 57, 1, 29, "Output"]
}, Open  ]],
Cell[5660, 231, 137, 3, 50, "Input"],

Cell[CellGroupData[{
Cell[5822, 238, 61, 1, 30, "Input"],
Cell[5886, 241, 54, 1, 29, "Output"]
}, Open  ]],
Cell[5955, 245, 82, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[6062, 250, 56, 1, 30, "Input"],
Cell[6121, 253, 54, 1, 29, "Output"]
}, Open  ]],
Cell[6190, 257, 80, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[6295, 262, 56, 1, 30, "Input"],
Cell[6354, 265, 54, 1, 29, "Output"]
}, Open  ]],
Cell[6423, 269, 129, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[6577, 276, 56, 1, 30, "Input"],
Cell[6636, 279, 54, 1, 29, "Output"]
}, Open  ]],
Cell[6705, 283, 147, 3, 50, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

